<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * A Font Icon select box.
 *
 * @property array $icons   A list of font-icon classes. [ 'class-name' => 'nicename', ... ]
 *                          Default Font Awesome icons. @see Control_Icon::get_icons().
 * @property array $include list of classes to include form the $icons property
 * @property array $exclude list of classes to exclude form the $icons property
 *
 * @since 1.0.0
 */
class Xs_Icon_Controler extends Elementor\Base_Data_Control {

	public function get_type() {
		return 'icon';
	}

	/**
	 * Get icons list
	 *
	 * @return array
	 */

	public static function get_icons() {

		$icons = array(

            'xsicon xsicon-align-center'    				=> 'xsicon xsicon-align-center',
            'xsicon xsicon-align-justify'   				=> 'xsicon xsicon-align-justify',
            'xsicon xsicon-align-left'           			=> 'xsicon xsicon-align-left',
            'xsicon xsicon-align-right'      				=> 'xsicon xsicon-align-right',
            'xsicon xsicon-angle-right'     				=> 'xsicon xsicon-angle-right',
			'xsicon xsicon-balance-scale'					=> 'xsicon xsicon-balance-scale',
            'xsicon xsicon-bars'            				=> 'xsicon xsicon-bars',
            'xsicon xsicon-bookmark'            			=> 'xsicon xsicon-bookmark',
            'xsicon xsicon-car'            					=> 'xsicon xsicon-car',
            'xsicon xsicon-check'            				=> 'xsicon xsicon-check',
            'xsicon xsicon-clock'            				=> 'xsicon xsicon-clock',
            'xsicon xsicon-comment-alt'            			=> 'xsicon xsicon-comment-alt',
            'xsicon xsicon-eye'            					=> 'xsicon xsicon-eye',
            'xsicon xsicon-facebook-f'          			=> 'xsicon xsicon-facebook-f',
            'xsicon xsicon-facebook-messenger'            	=> 'xsicon xsicon-facebook-messenger',
            'xsicon xsicon-folder'            				=> 'xsicon xsicon-folder',
            'xsicon xsicon-globe-europe'            		=> 'xsicon xsicon-globe-europe',
            'xsicon xsicon-heart'            				=> 'xsicon xsicon-heart',
            'xsicon xsicon-instagram'            			=> 'xsicon xsicon-instagram',
            'xsicon xsicon-linkedin-in'            			=> 'xsicon xsicon-linkedin-in',
			'xsicon xsicon-long-arrow-alt-left'				=> 'xsicon xsicon-long-arrow-alt-left',
            'xsicon xsicon-long-arrow-alt-right'            => 'xsicon xsicon-long-arrow-alt-right',
            'xsicon xsicon-microphone'            			=> 'xsicon xsicon-microphone',
            'xsicon xsicon-minus'            				=> 'xsicon xsicon-minus',
            'xsicon xsicon-pinterest-p'            			=> 'xsicon xsicon-pinterest-p',
            'xsicon xsicon-play'            				=> 'xsicon xsicon-play',
            'xsicon xsicon-plus'            				=> 'xsicon xsicon-plus',
            'xsicon xsicon-question-circle'            		=> 'xsicon xsicon-question-circle',
            'xsicon xsicon-quote-right'            			=> 'xsicon xsicon-quote-right',
			'xsicon xsicon-repeat'							=> 'xsicon xsicon-repeat',
            'xsicon xsicon-reply-all'            			=> 'xsicon xsicon-reply-all',
            'xsicon xsicon-search'            				=> 'xsicon xsicon-search',
            'xsicon xsicon-shopping-basket'            		=> 'xsicon xsicon-shopping-basket',
            'xsicon xsicon-spinner'            				=> 'xsicon xsicon-spinner',
            'xsicon xsicon-star'            				=> 'xsicon xsicon-star',
            'xsicon xsicon-thumbtack'            			=> 'xsicon xsicon-thumbtack',
            'xsicon xsicon-twitter'            				=> 'xsicon xsicon-twitter',
            'xsicon xsicon-user-regular'            		=> 'xsicon xsicon-user-regular',
            'xsicon xsicon-youtube'            				=> 'xsicon xsicon-youtube',
            'xsicon xsicon-angle-down'            			=> 'xsicon xsicon-angle-down',
            'xsicon xsicon-angle-left'            			=> 'xsicon xsicon-angle-left',
            'xsicon xsicon-angle-right'            			=> 'xsicon xsicon-angle-right',
            'xsicon xsicon-arrow-left'            			=> 'xsicon xsicon-arrow-left',
            'xsicon xsicon-arrow-right'            			=> 'xsicon xsicon-arrow-right',
            'xsicon xsicon-thumbtack'            			=> 'xsicon xsicon-thumbtack',
            'xsicon xsicon-arrow-up'            			=> 'xsicon xsicon-arrow-up',
            'xsicon xsicon-bag'            					=> 'xsicon xsicon-bag',
            'xsicon xsicon-bulb'            				=> 'xsicon xsicon-bulb',
            'xsicon xsicon-camera'            				=> 'xsicon xsicon-camera',
			'xsicon xsicon-cart'            				=> 'xsicon xsicon-cart',
			'xsicon xsicon-chair'            				=> 'xsicon xsicon-chair',
			'xsicon xsicon-comments'            			=> 'xsicon xsicon-comments',
			'xsicon xsicon-danger'            				=> 'xsicon xsicon-danger',
			'xsicon xsicon-desktop'            				=> 'xsicon xsicon-desktop',
			'xsicon xsicon-envelope-open'            		=> 'xsicon xsicon-envelope-open',
			'xsicon xsicon-hand'            				=> 'xsicon xsicon-hand',
			'xsicon xsicon-headset'            				=> 'xsicon xsicon-headset',
			'xsicon xsicon-heart-regular'            		=> 'xsicon xsicon-heart-regular',
			'xsicon xsicon-lamp'            				=> 'xsicon xsicon-lamp',
			'xsicon xsicon-map-marker'            			=> 'xsicon xsicon-map-marker',
			'xsicon xsicon-mobile'            				=> 'xsicon xsicon-mobile',
			'xsicon xsicon-paper-plane'            			=> 'xsicon xsicon-paper-plane',
			'xsicon xsicon-return'            				=> 'xsicon xsicon-return',
			'xsicon xsicon-rich'            				=> 'xsicon xsicon-rich',
			'xsicon xsicon-settings'            			=> 'xsicon xsicon-settings',
			'xsicon xsicon-share'            				=> 'xsicon xsicon-share',
			'xsicon xsicon-shirt'            				=> 'xsicon xsicon-shirt',
			'xsicon xsicon-shoe'            				=> 'xsicon xsicon-shoe',
			'xsicon xsicon-shopping-bag'            		=> 'xsicon xsicon-shopping-bag',
			'xsicon xsicon-shuffle'            				=> 'xsicon xsicon-shuffle',
			'xsicon xsicon-shuttle-van'            			=> 'xsicon xsicon-shuttle-van',
			'xsicon xsicon-teams'            				=> 'xsicon xsicon-teams',
			'xsicon xsicon-time'            				=> 'xsicon xsicon-time',
			'xsicon xsicon-ul-list'            				=> 'xsicon xsicon-ul-list',
			'xsicon xsicon-cross'            				=> 'xsicon xsicon-cross',
            'xsicon th'            							=> 'xsicon th',
		);

		return $icons;
	}

	/**
	 * Retrieve icons control default settings.
	 *
	 * Get the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */

	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */

	public function content_template() {
		?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">
				<select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php esc_attr_e( 'Select Icon', 'marketo' ); ?>">
					<option value=""><?php esc_html_e( 'Select Icon', 'marketo' ); ?></option>
					<# _.each( data.options, function( option_title, option_value ) { #>
					<option value="{{ option_value }}">{{{ option_title }}}</option>
					<# } ); #>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}

}
