(function ($, elementor) {
    "use strict";

    var Marketo = {

        init: function () {

            var widgets = {
                'xs-maps.default': Marketo.Map,
                'xs-woo-slider.default': Marketo.Product_Slider,
                'xs-woo-carousel.default': Marketo.Product_Carousel,
                'xs-woo-tab.default': Marketo.Product_Tab_Slider,
                'xs-sliders.default': Marketo.Slider,
                //'xs-countdown.default': Marketo.ContDown_Timer,
                'xs-nav-serch.default': Marketo.Nav_Search,
            };
            $.each(widgets, function (widget, callback) {
                elementor.hooks.addAction('frontend/element_ready/' + widget, callback);
            });
        },

        Map: function ($scope) {

            var $container = $scope.find('.marketo-maps'),
                map,
                init,
                pins;
            if (!window.google) {
                return;
            }

            init = $container.data('init');
            pins = $container.data('pins');
            map = new google.maps.Map($container[0], init);

            if (pins) {
                $.each(pins, function (index, pin) {

                    var marker,
                        infowindow,
                        pinData = {
                            position: pin.position,
                            map: map
                        };

                    if ('' !== pin.image) {
                        pinData.icon = pin.image;
                    }

                    marker = new google.maps.Marker(pinData);

                    if ('' !== pin.desc) {
                        infowindow = new google.maps.InfoWindow({
                            content: pin.desc
                        });
                    }

                    marker.addListener('click', function () {
                        infowindow.open(map, marker);
                    });

                    if ('visible' === pin.state && '' !== pin.desc) {
                        infowindow.open(map, marker);
                    }

                });
            }
        },

        Product_Slider: function ($scope) {
            let $dealsContainer = $scope.find('.product-slider-style-1');
            let $blockSliderContainer = $scope.find('.xs-product-slider-style-2');

            $($dealsContainer).each(function (index, element) {
                let $element = $(element).find('.xs-deal-of-the-day-section');
                new Swiper($element[0], {
                    slidesPerView: 1,
                    effect: 'slide',
                    mousewheelControl: 1,
                    navigation: {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                    },
                    breakpoints: {
                        0: {
                            slidesPerView: 1,
                        },
                        767: {
                            slidesPerView: 1,
                        },
                        1024: {
                            slidesPerView: 1,
                        },
                    },
                });
            });

            $($blockSliderContainer).each(function (index, element) {
                let $element = $(element).find('.product-block-slider');
                new Swiper($element[0], {
                    slidesPerView: 1,
                    effect: 'slide',
                    pagination: {
                        el: '.swiper-pagination',
                        clickable: true,
                    },
                    breakpoints: {
                        0: {
                            slidesPerView: 1,
                        },
                        767: {
                            slidesPerView: 1,
                        },
                        1024: {
                            slidesPerView: 1,
                        },
                    },
                });
            });

        },

        Product_Carousel: function ($scope) {
            //style 1
            var xs_product_slider_1 = $scope.find('.xs-product-slider-1');
            if (xs_product_slider_1.length > 0) {
                let controls = xs_product_slider_1.data('controls');
                let widget_id = controls.widget_id;
                new Swiper(xs_product_slider_1[0], {
                    slidesPerView: 1,
                    effect: 'fade',
                    navigation: {
                        nextEl: `.swiper-next-${widget_id}`,
                        prevEl: `.swiper-prev-${widget_id}`,
                    },
                });
            }

            //style 2
            var xs_deal_of_the_week = $scope.find('.xs-deal-of-the-week');
            if (xs_deal_of_the_week.length > 0) {
                let xs_deal_controls = xs_deal_of_the_week.data('controls');
                let deal_widget_id = xs_deal_controls.widget_id;
                new Swiper(xs_deal_of_the_week[0], {
                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true,
                    },
                    navigation: {
                        nextEl: `.swiper-next-${deal_widget_id}`,
                        prevEl: `.swiper-prev-${deal_widget_id}`,
                    },
                    breakpoints: {
                        0: {
                            slidesPerView: 1,
                        },
                        767: {
                            slidesPerView: 2,
                            spaceBetween: 30,
                        },
                        1024: {
                            slidesPerView: 1,
                        },
                    },
                });
            }

            //style 3
            var recent_view_slider = $scope.find('.recent-view-slider');
            if (recent_view_slider.length > 0) {
                new Swiper(recent_view_slider[0], {
                    slidesPerView: 6,
                    effect: 'slide',
                    autoplay: 5000,
                    breakpoints: {
                        0: {
                            slidesPerView: 1,
                        },
                        768: {
                            slidesPerView: 3,
                        },
                        1024: {
                            slidesPerView: 6,
                        }

                    }
                });
            }


            //style 4
            var xs_slider_7_col = $scope.find('.xs-slider-7-col');
            if (xs_slider_7_col.length > 0) {
                let controls = xs_slider_7_col.data('controls');
                let widget_id = controls.widget_id;
                new Swiper(xs_slider_7_col[0], {
                    slidesPerView: 7,
                    effect: 'slide',
                    navigation: {
                        nextEl: `.swiper-next-${widget_id}`,
                        prevEl: `.swiper-prev-${widget_id}`,
                    },
                    breakpoints: {
                        0: {
                            slidesPerView: 1,
                        },
                        768: {
                            slidesPerView: 3,
                        },
                        1024: {
                            slidesPerView: 7,
                        }

                    }
                });
            }

            //style 5
            var xs_product_slider_5 = $scope.find('.xs-product-slider-5');
            if (xs_product_slider_5.length > 0) {
                let controls = xs_product_slider_5.data('controls');
                let widget_id = controls.widget_id;
                new Swiper(xs_product_slider_5[0], {
                    slidesPerView: 1,
                    effect: 'fade',
                    navigation: {
                        nextEl: `.swiper-next-${widget_id}`,
                        prevEl: `.swiper-prev-${widget_id}`,
                    },
                });
            }

        },

        Product_Tab_Slider: function ($scope) {
            //tab slider style 2
            var xs_tab_slider_1 = $scope.find('.xs-tab-slider');
            if (xs_tab_slider_1.length > 0) {
                $scope.find('[data-toggle="tab"]').on('shown.bs.tab', function () {
                    var targetEl = $(this.hash).children('.swiper')[0];

                    targetEl.swiper.update();
                });
                new Swiper(xs_tab_slider_1[0], {
                    slidesPerView: 3,
                    effect: 'slide',
                    pagination: {
                        el: '.swiper-pagination',
                        clickable: true,
                    },
                    breakpoints: {
                        0: {
                            slidesPerView: 1,
                            slidesPerGroup: 1,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 30,
                            slidesPerGroup: 2,
                        },
                        1024: {
                            slidesPerView: 3,
                            spaceBetween: 30,
                            slidesPerGroup: 3,
                        }

                    }
                });
            }
            //tab slider style 3
            var xs_tab_slider_2 = $scope.find('.xs-tab-slider-6-col');
            if (xs_tab_slider_2.length > 0) {
                $scope.find('[data-toggle="tab"]').on('shown.bs.tab', function () {
                    var targetEl = $(this.hash).children('.swiper')[0];

                    targetEl.swiper.update();
                });
                new Swiper(xs_tab_slider_2[0], {
                    slidesPerView: 6,
                    effect: 'slide',
                    pagination: {
                        el: '.swiper-pagination',
                        clickable: true,
                    },
                    breakpoints: {
                        0: {
                            slidesPerView: 1,
                            slidesPerGroup: 1,
                        },
                        768: {
                            slidesPerView: 4,
                            slidesPerGroup: 4,
                        },
                        1024: {
                            slidesPerView: 6,
                            slidesPerGroup: 6,
                        }

                    }
                });
            }

            //tab slider style 7
            var xs_tab_slider_7 = $scope.find('.xs-product-slider-11');
            if (xs_tab_slider_7.length > 0) {
                $scope.find('[data-toggle="tab"]').on('shown.bs.tab', function () {
                    var targetEl = $(this.hash).children('.swiper')[0];

                    targetEl.swiper.update();
                });
                let controls = xs_tab_slider_7.data('controls');
                let widget_id = controls.widget_id;
                new Swiper(xs_tab_slider_7[0], {
                    slidesPerView: 3,
                    effect: 'slide',
                    navigation: {
                        nextEl: `.swiper-next-${widget_id}`,
                        prevEl: `.swiper-prev-${widget_id}`,
                    },
                    breakpoints: {
                        0: {
                            slidesPerView: 1,
                        },
                        768: {
                            slidesPerView: 2,
                        },
                        1024: {
                            slidesPerView: 3,
                        }

                    }
                });
            }
        },
        Slider: function ($scope) {
            let main_slider = $scope.find('.xs-banner');
            if (main_slider.length > 0) {
                let controls = main_slider.data('controls');
                let widget_id = controls.widget_id;
                new Swiper(main_slider[0], {
                    // Optional parameters
                    direction: "horizontal",
                    loop: false,
                    slidesPerView: 1,
                    grabCursor: true,
                    effect: "slide",
                    autoplay: {
                        delay: 10000,
                    },

                    // If we need pagination
                    pagination: {
                        el: ".swiper-pagination",
                        clickable: true,
                    },
                    navigation: {
                        nextEl: `.swiper-next-${widget_id}`,
                        prevEl: `.swiper-prev-${widget_id}`,
                        disabledClass: "swiper-button-disabled",
                    },
                });
            }
        },

        Nav_Search: function ($scope) {
            $scope.find('.xs-ele-nav-search-select').mySelect();
        }
    };

    $(window).on('elementor/frontend/init', Marketo.init);

}(jQuery, window.elementorFrontend));
